package gov.va.med.mhv.rxrefill.data.repository;

import gov.va.med.mhv.rxrefill.data.model.Prescription;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PrescriptionRepository extends JpaRepository<Prescription, Long>{

	/*
	   @Query("select p " +
		    "from Prescription p, Request r "+
		    "where p.isInactive = 0 "+
				"and p.userId = :userId " +
				"and p.status in ('active', 'submitted', 'suspended', 'refillinprocess') " +
				"and r.userId = p.userId " +
				"and r.institution.id = p.institution.id " +
				"and r.isInactive = 0 " +
				"and r.requestFunction in (3, 50) " +
				"and r.status = 'successful' " +
				"and r.modifiedDate = ( " +
					"select MAX(r1.modifiedDate) " +
					"from Request r1 " +
					"where r1.userId = p.userId " +
					"and r1.institution.id = p.institution.id " +
					"and r1.isInactive = 0 " +
					"and r1.requestFunction in (3, 50) " +
					"and r1.status = 'successful') " +
			"order by p.lastFillDate desc, p.prescriptionNumber asc")  
	*/
	
	
	@Query( "  select p from Prescription p,Request r1,Institution i1" +
	 		 " where p.isInactive = 0 and p.userId = :userId  and p.status in ('active', 'submitted', 'suspended', 'refillinprocess') "+
			 " and p.institution.id= i1.id and  p.userId= r1.userId and " +
	 		 " i1.id = r1.institution.id and r1.modifiedDate = (select max(r2.modifiedDate) from Request r2 " +
		     " where r2.institution.id = i1.id and r2.isInactive = 0 and r2.userId = p.userId " +
	 		 " and  r2.requestFunction in (3, 50) and r2.status = 'successful' ) and r1.isInactive = 0 " +
		     " and r1.requestFunction in (3, 50) and r1.status = 'successful' order by p.lastFillDate desc, p.prescriptionNumber asc")
	public List<Prescription> getActivePrescriptionsWithLastRequestSuccessful(@Param("userId") Long userId);

	/*
	  @Query("select p " +
		    "from Prescription p, Request r "+
		    "where p.isInactive = 0 "+
				"and p.userId = :userId " +
				"and p.status in ('active', 'submitted', 'suspended', 'refillinprocess') " +
				"and r.userId = p.userId " +
				"and r.institution.id = p.institution.id " +
				"and r.isInactive = 0 " +
				"and r.requestFunction in (3, 50) " +
				"and r.status <> 'successful' " +
				"and r.modifiedDate = ( " +
					"select MAX(r1.modifiedDate) " +
					"from Request r1 " +
					"where r1.userId = p.userId " +
					"and r1.institution.id = p.institution.id " +
					"and r1.isInactive = 0 " +
					"and r1.requestFunction in (3, 50) " +
					"and r1.status = 'successful') " +
			"order by p.lastFillDate desc, p.prescriptionNumber asc")
	 */
	
	@Query( "  select p from Prescription p,Request r1,Institution i1" +
	 		 " where p.isInactive = 0 and p.userId = :userId  and p.status in ('active', 'submitted', 'suspended', 'refillinprocess') "+
			 " and p.institution.id= i1.id and  p.userId= r1.userId and " +
	 		 " i1.id = r1.institution.id and r1.modifiedDate = (select max(r2.modifiedDate) from Request r2 " +
		     " where r2.institution.id = i1.id and r2.isInactive = 0 and r2.userId = p.userId " +
	 		 " and  r2.requestFunction in (3, 50) and r2.status <> 'successful' ) and r1.isInactive = 0 " +
		     " and r1.requestFunction in (3, 50) and r1.status <> 'successful' order by p.lastFillDate desc, p.prescriptionNumber asc")
	public List<Prescription> getActivePrescriptionsWithLastRequestUnsuccessful(@Param("userId") Long userId);

/*	
 @Query("select p " +
				"from Prescription p, Request r " +
				"where  " +
					"p.isInactive = 0 " +
					"and p.userId = :userId " +
					"and p.status <> 'deleted' " +
					"and r.userId = p.userId " +
					"and r.institution.institutionId = p.institution.institutionId " +
					"and r.isInactive = 0 " +
					"and r.requestFunction in (4, 50) " +
					"and r.status = 'successful' " +
					"and r.modifiedDate = ( " +
						"select MAX(r1.modifiedDate) " +
						"from Request r1 " +
						"where " +
							"r1.isInactive = 0  " +
							"and r1.userId = p.userId " +
							"and r1.institution.institutionId = p.institution.institutionId " +
							"and r1.requestFunction in (4, 50) " +
							"and r1.status = 'successful' " +
					")") 
*/
	
	@Query( "  select p from Prescription p,Request r1,Institution i1" +
	 		 " where p.isInactive = 0 and p.userId = :userId  and p.status <> 'deleted' "+
			 " and p.institution.id= i1.id and  p.userId= r1.userId and " +
	 		 " i1.id = r1.institution.id and r1.modifiedDate = (select max(r2.modifiedDate) from Request r2 " +
		     " where r2.institution.id = i1.id and r2.isInactive = 0 and r2.userId = p.userId " +
	 		 " and  r2.requestFunction in (4, 50) and r2.status = 'successful' ) and r1.isInactive = 0 " +
		     " and r1.requestFunction in (4, 50) and r1.status = 'successful' ")
	public List<Prescription> getHistoricalPrescriptionsWithLastRequestSuccessful(@Param("userId") Long userId);

/*	
@Query("select p " +
				"from Prescription p, Request r " +
				"where " +
					"p.isInactive = 0 " +
					"and p.userId = :userId " +
					"and p.status <> 'deleted' " +
					"and r.userId = p.userId " +
					"and r.institution.institutionId = p.institution.institutionId " +
					"and r.isInactive = 0 " +
					"and r.requestFunction in (4, 50) " +
					"and r.status <> 'successful' " +
					"and r.modifiedDate = ( " +
						"select MAX(r1.modifiedDate) " +
						"from Request r1 " +
						"where " +
							"r1.isInactive = 0 " +
							"and r1.userId = p.userId " +
							"and r1.institution.institutionId = p.institution.institutionId " +
							"and r1.requestFunction in (4, 50) " +
							"and r1.status <> 'successful' " +
					")") 
*/
	
	@Query( "  select p from Prescription p,Request r1,Institution i1" +
	 		 " where p.isInactive = 0 and p.userId = :userId  and p.status <> 'deleted' "+
			 " and p.institution.id= i1.id and  p.userId= r1.userId and " +
	 		 " i1.id = r1.institution.id and r1.modifiedDate = (select max(r2.modifiedDate) from Request r2 " +
		     " where r2.institution.id = i1.id and r2.isInactive = 0 and r2.userId = p.userId " +
	 		 " and  r2.requestFunction in (4, 50) and r2.status <>'successful' ) and r1.isInactive = 0 " +
		     " and r1.requestFunction in (4, 50) and r1.status <> 'successful' ")
	public List<Prescription> getHistoricalPrescriptionsWithLastRequestUnsuccessful(@Param("userId") Long userId);
	
	

	@Query("select pr " +
			"from Prescription pr " +
			"where pr.isInactive = 0 " +
			"and pr.userId = :userId " +
			"and pr.institution.id = :institutionId")
	public List<Prescription> getPrescriptionsForInactivation(@Param("userId") Long userId, @Param("institutionId") Long institutionId);

	@Query("select pr " +
			"from Prescription pr " +
			"where pr.isInactive = 0 " +
			"and pr.userId = :userId")
	public List<Prescription> getPrescriptionsForPatient(@Param("userId") Long userId);

	@Query("select pr " +
			"from Prescription pr " +
			"where pr.isInactive = 0 " +
			"and pr.userId = :userId " +
			"and pr.status='active'")
	public List<Prescription> getActivePatientPrescriptions(@Param("userId") Long userId);

	@Query("select pr " +
			"from Prescription pr " +
			"where pr.isInactive = 0 " +
			"and pr.userId = :userId " +
			"and pr.institution.id = :institutionId " +
			"and pr.prescriptionNumber = :prescriptionNumber")
	public List<Prescription> getPrescriptionByPatientSiteNumber(@Param("userId") Long userId, @Param("institutionId") Long institutionId, @Param("prescriptionNumber") String prescriptionNumber);
	
	@Query("select pr " +
			"from Prescription pr " +
			"where pr.isInactive = 0 " +
			"and pr.institution.stationNumber = :stationNumber " +
			"and pr.prescriptionNumber = :prescriptionNumber")
	public List<Prescription> getPrescriptionDetailsForPrescriptionNumber(
			@Param("prescriptionNumber") String prescriptionNumber,
			@Param("stationNumber") String stationNumber
			);
	
	
	@Query("select prescription from Prescription prescription where prescription.id = :id")
	Prescription getPrescriptionById(@Param("id") Long id);
	
	
	@Query("select pr " +
			"from Prescription pr " +
			"where pr.userId = :userId " +
			 "and pr.id=(select MAX(pr2.id) from Prescription pr2 WHERE pr2.userId = :userId and pr2.prescriptionNumber = pr.prescriptionNumber) " +
			"order by pr.drugName")
	public List<Prescription> getAllPrescriptionsForPatient(@Param("userId") Long userId);

	
	@Query("select count(pr) " +
			"from Prescription pr " +
			"where pr.userId = :userId " +
			"and pr.institution.institutionId = :institutionId")
	public Long getAllPrescriptionsForUserPerInstitution(@Param("userId") Long userId, @Param("institutionId") Long institutionId);

}